#ifndef BLIKAC_H
#define BLIKAC_H

#include "Arduino.h"
#include "LedControl.h"

/*
 * Abstraktni predek.
 * Implementuje blikani.
 */
class Blikac
{
	unsigned long dobaZapnuti; // Kolik milisekund trva zapnuti (sviceni).
	unsigned long dobaVypnuti; // Kolik milisekund trva vypnuti (tma).
	int stav;                  // Stav. Jeden z VYPNUTO, ZAPNUTO, BLIKA_SVITI, BLIKA_NESVITI.
	
	virtual void zapni() = 0;  // Zapne vystup (rozsviti svetelko nebo zobrazi text).
	virtual void vypni() = 0;  // Vypne vystup (zhasne svetelko nebo smaze text).
	int maSvitit();            // Otestuje, zda v tento cas ma byt vystup zapnuty pri blikani. Volat jen pri blikani.
public:
	Blikac();                  // Inicializace.
	void loop();               // Toto se musi volat vzdy (nejlepe na zacatku) ve funkci loop().
	void nastavDoby(unsigned long dobaZapnuti, unsigned long dobaVypnuti); // Nastavi rychlost blikani.
	void svit();               // Bude pouze svitit.
	void zhasni();             // Nebude svitit.
	void blikej();             // Bude blikat nastavenou rychlosti.
};

/*
 * Blika napr. LEDkou na vystupnim pinu.
 */
class BlikacPin : public Blikac
{
	int pin;              // Cislo pinu, na ktery je pripojena LEDka.
	
	virtual void zapni();
	virtual void vypni();
public:
	BlikacPin(int pin);   // Inicializace. pin je cislo vystupniho pinu.
};

/*
 * Vola LedControl::setIntensity().
 * Blika textem na displeji.
 */
class BlikacText : public Blikac
{
	LedControl *ledControl;  // Ovladac displeje.
	int adresa;              // Adresa displeje.
	int jas;                 // Jas displeje, kdyz sviti.
	
	virtual void zapni();
	virtual void vypni();
public:
	BlikacText(LedControl *ledControl, int adresa); // Inicializace.
	void nastavJas(int jas); // Nastavi jas displeje, kdyz sviti.
};

#endif

