#include "Arduino.h"
#include "LedControl.h"
#include "blikac.h"

enum
{
	VYPNUTO,
	ZAPNUTO,
	BLIKA_SVITI,
	BLIKA_NESVITI
};

Blikac::Blikac()
{
	dobaZapnuti = 100;
	dobaVypnuti = 100;
	stav = VYPNUTO;
}

int Blikac::maSvitit()
{
	return millis() % (dobaZapnuti + dobaVypnuti) < dobaZapnuti;
}

void Blikac::loop()
{
	switch ( stav )
	{
	case VYPNUTO:
		break;
	case ZAPNUTO:
		break;
	case BLIKA_SVITI:
		if ( ! maSvitit() )
		{
			stav = BLIKA_NESVITI;
			vypni();
		}
		break;
	case BLIKA_NESVITI:
		if ( maSvitit() )
		{
			stav = BLIKA_SVITI;
			zapni();
		}
		break;
	}
}

void Blikac::nastavDoby(unsigned long dobaZapnuti, unsigned long dobaVypnuti)
{
	this->dobaZapnuti = dobaZapnuti;
	this->dobaVypnuti = dobaVypnuti;
}

void Blikac::svit()
{
	stav = ZAPNUTO;
	zapni();
}

void Blikac::zhasni()
{
	stav = VYPNUTO;
	vypni();
}

void Blikac::blikej()
{
	switch ( stav )
	{
	case VYPNUTO:
	case ZAPNUTO:
		if ( maSvitit() )
		{
			stav = BLIKA_SVITI;
			zapni();
		}
		else
		{
			stav = BLIKA_NESVITI;
			vypni();
		}
		break;
	case BLIKA_SVITI:
		break;
	case BLIKA_NESVITI:
		break;
	}
}

BlikacPin::BlikacPin(int pin)
{
	this->pin = pin;
}

void BlikacPin::zapni()
{
	digitalWrite(pin, HIGH);
}

void BlikacPin::vypni()
{
	digitalWrite(pin, LOW);
}

BlikacText::BlikacText(LedControl *ledControl, int adresa)
{
	this->ledControl = ledControl;
	this->adresa = adresa;
	this->jas = 1;
}

void BlikacText::zapni()
{
	ledControl->setIntensity(adresa, jas);
}

void BlikacText::vypni()
{
	ledControl->setIntensity(adresa, 0);
}

void BlikacText::nastavJas(int jas)
{
	this->jas = jas;
}

