#include "LedControl.h"
LedControl lc = LedControl(2,4,3,1);

int ThermistorPina = A0;
int Va;
int tempC;
float Reading;
float R1 = 10000;
float logR2, R2, T, Tc, Tca, Tf;
float c1 = 1.009249522e-03, c2 = 2.378405444e-04, c3 = 2.019202697e-07;
char minus;

void setup(){
  lc.shutdown(0, false);
  lc.setIntensity(0, 0); 
  lc.clearDisplay(0);}
 
void loop(){
  Va = analogRead(ThermistorPina); 
  R2 = R1 * (1023.0 / (float)Va -1);
  logR2 = log(R2);
  T = (1.0 / (c1 + c2*logR2 + c3*logR2*logR2*logR2));
  Tca = (T - 273.15);
  Tf = (T * 9.0)/ 5.0 + 32.0;
  tempC=Tca*10; 
  minus = ' ';
  if ( tempC < 0 ){minus = '-'; tempC *= -1;}
 
  int temp1 =  (tempC % 10); // one of temp
  int temp2 =  (tempC / 10) % 10; // tens of temp
  int temp3 =  (tempC / 100) % 10; // units of temp

   lc.setRow(0,7,15);     
   lc.setRow(0,6,0);     
   lc.setRow(0,5,0);
 if ( temp3 == 0 ){
   lc.setChar(0,4,' ',false);
   lc.setChar(0,5,minus,false);}
 else {lc.setChar(0,5,minus,false);
   lc.setDigit(0,4,temp3,false);}   
   lc.setDigit(0,3,temp2,true);
   lc.setDigit(0,2,temp1,false);
   lc.setRow(0,1,99);
   lc.setRow(0,0,78); 
delay(300);
}
