/*

Author Dumitru Novitchi

 */

#define F_CPU 8000000UL

#include <avr/io.h>
#include <avr/interrupt.h>
#include <stdlib.h>
#include <avr/eeprom.h>
#include "HD44780.h"
#include "int_to_char.h"

#define Voltage_Chanel ADMUX = ( 1 << MUX1 ) | ( 1 << MUX2 ) // Diferential mode between PB4 -> PB3
#define Current_Chanel ADMUX = ( 1 << MUX0 ) // Current PB2
#define ADC_Start ADCSRA |= ( 1 << ADSC )
#define ADC_OFF ADCSRA &= ~( 1 << ADIE )

#define Gain 90
#define Divide 6

// calibration -----------------------
//#define offset_error 90
//#define gain_error 1011
//#define U3C_voltage 4600
#define Ref_Volt  5250
//-------------------------------------
//#define LCD_I2C_addr 0x4E         // PCF8574T = 0x4E , PCF8574AT = 0x7E set in library HD44780.h


volatile uint32_t Voltage_ADC_value = 0x00;
volatile uint32_t Current_ADC_value = 0x00;
volatile uint16_t Measure_count = 0x00;



void ADC_init (void)
{

    DDRB &= ~( 1 << PB4 );// Voltage+
    DDRB &= ~( 1 << PB3 );// Voltage-
    DDRB &= ~( 1 << PB2 );// Current

    PORTB &= ~( 1 << PB4 );// Voltage+
    PORTB &= ~( 1 << PB3 );// Voltage-
    PORTB &= ~( 1 << PB2 );// Current

    ADMUX = 0x00;  // cleanup
    ADCSRA = 0x00; // cleanup
    ADCSRB = 0x00; // cleanup
    DIDR0 = 0x00;  // cleanup

    Voltage_Chanel;

    ADCSRA |= ( 1 << ADEN ); // ADC Enable
    ADCSRA |= ( 1 << ADIE ); // ADC Interrupt Enable
    ADCSRA |= ( 1 << ADPS0 ) | ( 1 << ADPS1 ) | ( 1 << ADPS2 ); // ADC Prescaler 128
    ADCSRA |= ( 1 << ADATE ); // ADC Auto Trigger Enable
    DIDR0 = ( 1 << ADC1D ) | ( 1 << ADC2D ) | ( 1 << ADC3D);
    //ADCSRB = ( 1 << BIN );

    MCUCR |= ( 1 << SE ); //sleep enable
    MCUCR |= ( 1 << SM0);// ADC noise reduction
    PRR = ( 1 << PRTIM1 ) | ( 1 << PRTIM0 ) | ( 1 << PRUSI );// power off

    ADC_Start;

}

ISR ( ADC_vect )
{

    if ( Measure_count == 0) // change channel
        Voltage_Chanel;


    if ( Measure_count == 267) // change channel
        Current_Chanel;


    if ((Measure_count > 10) && (Measure_count < 267)) // discard first 0-9 measurements
        Voltage_ADC_value += ( ADC );  // 255 samples


    if ((Measure_count > 277) && (Measure_count < 534)) // discard first 267-277 measurements
        Current_ADC_value += ADC;   // 255 samples


    if (Measure_count <= 534)   // count to 535 and stop
        Measure_count++;

}

uint8_t EEMEM Offset_Call_status;
uint8_t EEMEM Gain_Call_status;
uint16_t EEMEM offset_error;
uint16_t EEMEM gain_error;
uint16_t EEMEM u3c_voltage;
int main(void)
{

    char LCD_RAM[5];
    uint32_t Voltage = 0;
    uint32_t Current = 0;
    uint16_t offset_error_ram = 0;
    uint16_t gain_error_ram = 0;
    uint16_t u3c_voltage_ram = 0;

    ADC_init();
    LCD_init();
    i2c_init();

    LCD_light_ON = True;
    LCD_write_string("Voltage ",LCD_char_addr(0x00));
    LCD_write_string("Current ",LCD_char_addr(0x09));

    sei(); // interrupt enable

    if ((eeprom_read_byte(&Offset_Call_status) > 1) || (eeprom_read_byte(&Gain_Call_status) > 1))

    {

    _delay_ms(5000);
    Measure_count = 0;  //cleanup
    Voltage_ADC_value = 0;  // cleanup
    Current_ADC_value = 0;  //cleanup

    while (Measure_count != 535)
        asm volatile ("sleep");

     if (Measure_count == 535)
        {
            cli();

            Voltage_ADC_value = Voltage_ADC_value >> 4;
            Current_ADC_value = Current_ADC_value >> 4;


            Voltage = (Voltage_ADC_value * Ref_Volt) >> 14;
            Current_ADC_value = ((uint32_t)Current_ADC_value * Ref_Volt) >> 14;

            Voltage = Voltage * Divide;
            //Voltage *= 1000;
            //Voltage /= 1000;

            Current = Current_ADC_value;
           // Current = abs( (uint32_t)U3C_voltage - Current_ADC_value ); //
           // Current = Current * 100;
           // Current /= Gain;


            int_to_char((uint16_t)Voltage,LCD_RAM);



            LCD_write_char(LCD_RAM[0],LCD_char_addr(0x40));
            //LCD_write(LCD_RAM[0],LCD_data);
            LCD_write(LCD_RAM[1],LCD_data);
            LCD_write('.',LCD_data);
            LCD_write(LCD_RAM[2],LCD_data);
            LCD_write(LCD_RAM[3],LCD_data);
            LCD_write(LCD_RAM[4],LCD_data);
            LCD_write('V',LCD_data);


            int_to_char((uint16_t)Current,LCD_RAM);

            LCD_write_char(LCD_RAM[0],LCD_char_addr(0x49));
            //LCD_write(LCD_RAM[0],LCD_data);
            LCD_write(LCD_RAM[1],LCD_data);
            LCD_write('.',LCD_data);
            LCD_write(LCD_RAM[2],LCD_data);
            LCD_write(LCD_RAM[3],LCD_data);
            LCD_write(LCD_RAM[4],LCD_data);
            LCD_write('A',LCD_data);

            Voltage_ADC_value = 0; // cleanup
            Current_ADC_value = 0; // cleanup
            Measure_count = 0;     // cleanup

            _delay_ms(2000);

            sei();

        }

    if (eeprom_read_byte(&Offset_Call_status) > 1)
    {
        eeprom_write_word(&offset_error,0);
        eeprom_write_word(&u3c_voltage,4500);

    }

    if (eeprom_read_byte(&Gain_Call_status) > 1)
    {
        eeprom_write_word(&gain_error,1000);

    }

    if ((eeprom_read_byte(&Offset_Call_status) > 1) && (Voltage < 200))
     {
         eeprom_write_word(&offset_error,Voltage);
         eeprom_write_word(&u3c_voltage,Current);
         eeprom_write_byte(&Offset_Call_status,0);
     }

     if ((eeprom_read_byte(&Gain_Call_status) > 1) && (Voltage > 27000))
     {
         Voltage *= 1000;
         Voltage /= 29000;
         eeprom_write_word(&gain_error,(uint16_t)Voltage);
         eeprom_write_byte(&Gain_Call_status,0);
     }

    }

     offset_error_ram = eeprom_read_word(&offset_error);
     gain_error_ram = eeprom_read_word(&gain_error);
     u3c_voltage_ram = eeprom_read_word(&u3c_voltage);




    // Insert code

    while(1)
    {



        if (Measure_count == 535)
        {
            cli();

            Voltage_ADC_value = Voltage_ADC_value >> 4;
            Current_ADC_value = Current_ADC_value >> 4;


            Voltage = (Voltage_ADC_value * Ref_Volt) >> 14;
            Current_ADC_value = ((uint32_t)Current_ADC_value * Ref_Volt) >> 14;

            Voltage = Voltage * Divide;
            if (Voltage <= offset_error_ram + 1)
                Voltage = abs(Voltage - offset_error_ram);
            Voltage *= 1000;
            Voltage /= gain_error_ram;


            Current = abs( (uint32_t)u3c_voltage_ram - Current_ADC_value ); //
            Current = Current * 100;
            Current /= Gain;


            int_to_char((uint16_t)Voltage,LCD_RAM);



            LCD_write_char(LCD_RAM[0],LCD_char_addr(0x40));
            //LCD_write(LCD_RAM[0],LCD_data);
            LCD_write(LCD_RAM[1],LCD_data);
            LCD_write('.',LCD_data);
            LCD_write(LCD_RAM[2],LCD_data);
            LCD_write(LCD_RAM[3],LCD_data);
            LCD_write(LCD_RAM[4],LCD_data);
            LCD_write('V',LCD_data);


            int_to_char((uint16_t)Current,LCD_RAM);

            LCD_write_char(LCD_RAM[0],LCD_char_addr(0x49));
            //LCD_write(LCD_RAM[0],LCD_data);
            LCD_write(LCD_RAM[1],LCD_data);
            LCD_write('.',LCD_data);
            LCD_write(LCD_RAM[2],LCD_data);
            LCD_write(LCD_RAM[3],LCD_data);
            LCD_write(LCD_RAM[4],LCD_data);
            LCD_write('A',LCD_data);

            Voltage_ADC_value = 0; // cleanup
            Current_ADC_value = 0; // cleanup
            Measure_count = 0;     // cleanup

            //_delay_ms(1000);

            sei();

        }

       asm volatile ("sleep");

    }


    return 0;
}
