#ifndef HD44780_H_INCLUDED
#define HD44780_H_INCLUDED

#define F_CPU 8000000UL

#include <avr/io.h>
#include "i2cmaster.h"
#include <util/delay.h>

#define True         0x01
#define False        0x00

#define LCD_I2C_addr 0x4E         // PCF8574T = 0x4E , PCF8574AT = 0x7E

#define NUL          ' '         // end of string, Space
#define LCD_command  0b11111110   // Write command for LCD
#define LCD_data     0b11111111   // Write data for LCD
#define LCD_enable    0b11111011   // Latch data to output LCD
#define LCD_char_addr(x) (0x80 + x) // Write addres for LCD 0b1000000 = 0x80 special command for addres , x is address
#define CGRAM_addr(x)    (0x40 + x) // Write addres  0b0100000 = 0x40 special command for CGRAM addres , x is address

// LCD special command

// LCD special command

#define Clear_Display      0x01
#define Return_Home        0x02
#define Shift_Left         0x07
#define Shift_Right        0x05
#define Display_Off        0x08
#define Display_ON         0x0C
#define Cursor_Off         0x0C
#define Cursor_ON          0x0E
#define Cursor_ON_blinking 0x0F


//LCD_char_addr() // 0x00 - first line
                  // 0x40 - second line
                  //0x14
extern volatile uint8_t LCD_light_ON;
extern void LCD_write( char data, uint8_t command_or_data);
extern void LCD_init (void);
extern void LCD_write_char (char data, uint8_t position);
extern void LCD_write_string (char *data, uint8_t position);

#endif // HD44780_H_INCLUDED
