#include "HD44780.h"

volatile uint8_t LCD_light_ON;

void LCD_write( char data, uint8_t command_or_data) {

    uint8_t send_data = 0;

i2c_start_wait(LCD_I2C_addr + I2C_WRITE); // start comunication

if (LCD_light_ON == True) {

        send_data = (data & 0xF0);
        send_data |= 0b00001101;

i2c_write(send_data & command_or_data); // send High four bits

i2c_write(send_data & command_or_data & LCD_enable);  // Write data to LCD, E pins

_delay_us(60);

send_data = (data & 0x0F) << 4;
        send_data |= 0b00001101;

i2c_write(send_data & command_or_data);   // Low four bits

i2c_write(send_data & command_or_data & LCD_enable);                                     // Write data to LCD, E pins

_delay_us(60);

}

else {

        send_data = (data & 0xF0);
        send_data |= 0b00000101;

  i2c_write(send_data & command_or_data); // send High four bits

  i2c_write(send_data & command_or_data & LCD_enable);                                     // Write data to LCD, E pins

  _delay_us(60);

   send_data = (data & 0x0F) << 4;
        send_data |= 0b00000101;


  i2c_write(send_data & command_or_data);   // Low four bits

  i2c_write(send_data & command_or_data & LCD_enable);// Write data to LCD, E pins

  _delay_us(60);

}

i2c_stop();                                                 // end comunication

}

void LCD_init (void) {

LCD_write(0b00110011,LCD_command);

_delay_ms(2);

LCD_write(0b00110010,LCD_command);

_delay_ms(2);

LCD_write(0b00100000,LCD_command);
LCD_write(0b00101100,LCD_command);
LCD_write(0b00000001,LCD_command); // Clear LCD and return home, delay 3ms after
_delay_ms(3);
LCD_write(0b00001100,LCD_command);
LCD_write(0b00000110,LCD_command);

}

void LCD_write_char (char data, uint8_t position) {

LCD_write(position,LCD_command);

LCD_write(data,LCD_data);

}

void LCD_write_string (char *data, uint8_t position) {

LCD_write(position,LCD_command);

while (*(data) != NUL) {

    LCD_write(*(data++),LCD_data); // inkrementovanie adresy o 1

}
}


