;; Generator znaku v rastru 8x8
;;
;; Urceno pro prekladac TASM.EXE
;;
;; Znaky jsou prevzaty ze ZX 81 (semigrafika) a ZX Spectrum (alfanumerika)
;; Kodovani alfanumeriky od 20h odpovida ASCII kodu 
;; znaky 00h - 1Fh jsou ze ZX 81
;; znaky 20h - 7Fh jsou ze ZX SPECTRUM
;; Celkova velikost binarky je 1KB (1024 byte)
;;
;; Znaky 00h, 0Bh - 1Fh se opakuji a je mozne je predefinovat na vlastni znaky
;; predefinovani je jednoduche a lze to delat ciste graficky pohledem
;; 1 = svitici bod, 0 = zhasnuty bod
;;
;; Pripravil NOSTALCOMP 2023
        
        .org 00000h
        
; ------------------------
; THE 'ZX81 CHARACTER SET'
; ------------------------
;https://www.tablix.org/~avian/spectrum/rom/zx81.htm

; $00 - Character: ' '          CHR$(0)

        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00000000

; $01 - Character: mosaic       CHR$(1)

        .db    %11110000
        .db    %11110000
        .db    %11110000
        .db    %11110000
        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00000000


; $02 - Character: mosaic       CHR$(2)

        .db    %00001111
        .db    %00001111
        .db    %00001111
        .db    %00001111
        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00000000


; $03 - Character: mosaic       CHR$(3)

        .db    %11111111
        .db    %11111111
        .db    %11111111
        .db    %11111111
        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00000000

; $04 - Character: mosaic       CHR$(4)

        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %11110000
        .db    %11110000
        .db    %11110000
        .db    %11110000

; $05 - Character: mosaic       CHR$(1)

        .db    %11110000
        .db    %11110000
        .db    %11110000
        .db    %11110000
        .db    %11110000
        .db    %11110000
        .db    %11110000
        .db    %11110000

; $06 - Character: mosaic       CHR$(1)

        .db    %00001111
        .db    %00001111
        .db    %00001111
        .db    %00001111
        .db    %11110000
        .db    %11110000
        .db    %11110000
        .db    %11110000

; $07 - Character: mosaic       CHR$(1)

        .db    %11111111
        .db    %11111111
        .db    %11111111
        .db    %11111111
        .db    %11110000
        .db    %11110000
        .db    %11110000
        .db    %11110000

; $08 - Character: mosaic       CHR$(1)

        .db    %10101010
        .db    %01010101
        .db    %10101010
        .db    %01010101
        .db    %10101010
        .db    %01010101
        .db    %10101010
        .db    %01010101

; $09 - Character: mosaic       CHR$(1)

        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %10101010
        .db    %01010101
        .db    %10101010
        .db    %01010101

; $0A - Character: mosaic       CHR$(10)

        .db    %10101010
        .db    %01010101
        .db    %10101010
        .db    %01010101
        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00000000

; $0B - Character: '"'          CHR$(11)

        .db    %00000000
        .db    %00100100
        .db    %00100100
        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00000000

; $0B - Character:  L           CHR$(12)

        .db    %00000000
        .db    %00011100
        .db    %00100010
        .db    %01111000
        .db    %00100000
        .db    %00100000
        .db    %01111110
        .db    %00000000

; $0B - Character: '$'          CHR$(13)

        .db    %00000000
        .db    %00001000
        .db    %00111110
        .db    %00101000
        .db    %00111110
        .db    %00001010
        .db    %00111110
        .db    %00001000

; $0B - Character: ':'          CHR$(14)

        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00010000
        .db    %00000000
        .db    %00000000
        .db    %00010000
        .db    %00000000

; $0B - Character: '?'          CHR$(15)

        .db    %00000000
        .db    %00111100
        .db    %01000010
        .db    %00000100
        .db    %00001000
        .db    %00000000
        .db    %00001000
        .db    %00000000

; $10 - Character: '('          CHR$(16)

        .db    %00000000
        .db    %00000100
        .db    %00001000
        .db    %00001000
        .db    %00001000
        .db    %00001000
        .db    %00000100
        .db    %00000000

; $11 - Character: ')'          CHR$(17)

        .db    %00000000
        .db    %00100000
        .db    %00010000
        .db    %00010000
        .db    %00010000
        .db    %00010000
        .db    %00100000
        .db    %00000000

; $12 - Character: '>'          CHR$(18)

        .db    %00000000
        .db    %00000000
        .db    %00010000
        .db    %00001000
        .db    %00000100
        .db    %00001000
        .db    %00010000
        .db    %00000000

; $13 - Character: '<'          CHR$(19)

        .db    %00000000
        .db    %00000000
        .db    %00000100
        .db    %00001000
        .db    %00010000
        .db    %00001000
        .db    %00000100
        .db    %00000000

; $14 - Character: '='          CHR$(20)

        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00111110
        .db    %00000000
        .db    %00111110
        .db    %00000000
        .db    %00000000

; $15 - Character: '+'          CHR$(21)

        .db    %00000000
        .db    %00000000
        .db    %00001000
        .db    %00001000
        .db    %00111110
        .db    %00001000
        .db    %00001000
        .db    %00000000

; $16 - Character: '-'          CHR$(22)

        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00111110
        .db    %00000000
        .db    %00000000
        .db    %00000000

; $17 - Character: '*'          CHR$(23)

        .db    %00000000
        .db    %00000000
        .db    %00010100
        .db    %00001000
        .db    %00111110
        .db    %00001000
        .db    %00010100
        .db    %00000000

; $18 - Character: '/'          CHR$(24)

        .db    %00000000
        .db    %00000000
        .db    %00000010
        .db    %00000100
        .db    %00001000
        .db    %00010000
        .db    %00100000
        .db    %00000000

; $19 - Character: ';'          CHR$(25)

        .db    %00000000
        .db    %00000000
        .db    %00010000
        .db    %00000000
        .db    %00000000
        .db    %00010000
        .db    %00010000
        .db    %00100000

; $1A - Character: ','          CHR$(26)

        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00001000
        .db    %00001000
        .db    %00010000

; $1B - Character: '"'          CHR$(27)

        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00011000
        .db    %00011000
        .db    %00000000

; $1C - Character: '0'          CHR$(28)

        .db    %00000000
        .db    %00111100
        .db    %01000110
        .db    %01001010
        .db    %01010010
        .db    %01100010
        .db    %00111100
        .db    %00000000

; $1D - Character: '1'          CHR$(29)

        .db    %00000000
        .db    %00011000
        .db    %00101000
        .db    %00001000
        .db    %00001000
        .db    %00001000
        .db    %00111110
        .db    %00000000

; $1E - Character: '2'          CHR$(30)

        .db    %00000000
        .db    %00111100
        .db    %01000010
        .db    %00000010
        .db    %00111100
        .db    %01000000
        .db    %01111110
        .db    %00000000

; $1F - Character: '3'          CHR$(31)

        .db    %00000000
        .db    %00111100
        .db    %01000010
        .db    %00001100
        .db    %00000010
        .db    %01000010
        .db    %00111100
        .db    %00000000

; -------------------------------
; THE 'ZX SPECTRUM CHARACTER SET'
; -------------------------------
; https://www.tablix.org/~avian/spectrum/rom/zx82.htm

; $20 - Character: ' '          CHR$(32)
        
        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00000000

; $21 - Character: '!'          CHR$(33)

        .db    %00000000
        .db    %00010000
        .db    %00010000
        .db    %00010000
        .db    %00010000
        .db    %00000000
        .db    %00010000
        .db    %00000000

; $22 - Character: '"'          CHR$(34)

        .db    %00000000
        .db    %00100100
        .db    %00100100
        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00000000

; $23 - Character: '#'          CHR$(35)

        .db    %00000000
        .db    %00100100
        .db    %01111110
        .db    %00100100
        .db    %00100100
        .db    %01111110
        .db    %00100100
        .db    %00000000

; $24 - Character: '$'          CHR$(36)

        .db    %00000000
        .db    %00001000
        .db    %00111110
        .db    %00101000
        .db    %00111110
        .db    %00001010
        .db    %00111110
        .db    %00001000

; $25 - Character: '%'          CHR$(37)

        .db    %00000000
        .db    %01100010
        .db    %01100100
        .db    %00001000
        .db    %00010000
        .db    %00100110
        .db    %01000110
        .db    %00000000

; $26 - Character: '&'          CHR$(38)

        .db    %00000000
        .db    %00010000
        .db    %00101000
        .db    %00010000
        .db    %00101010
        .db    %01000100
        .db    %00111010
        .db    %00000000

; $27 - Character: '''          CHR$(39)

        .db    %00000000
        .db    %00001000
        .db    %00010000
        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00000000

; $28 - Character: '('          CHR$(40)

        .db    %00000000
        .db    %00000100
        .db    %00001000
        .db    %00001000
        .db    %00001000
        .db    %00001000
        .db    %00000100
        .db    %00000000

; $29 - Character: ')'          CHR$(41)

        .db    %00000000
        .db    %00100000
        .db    %00010000
        .db    %00010000
        .db    %00010000
        .db    %00010000
        .db    %00100000
        .db    %00000000

; $2A - Character: '*'          CHR$(42)

        .db    %00000000
        .db    %00000000
        .db    %00010100
        .db    %00001000
        .db    %00111110
        .db    %00001000
        .db    %00010100
        .db    %00000000

; $2B - Character: '+'          CHR$(43)

        .db    %00000000
        .db    %00000000
        .db    %00001000
        .db    %00001000
        .db    %00111110
        .db    %00001000
        .db    %00001000
        .db    %00000000

; $2C - Character: ','          CHR$(44)

        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00001000
        .db    %00001000
        .db    %00010000

; $2D - Character: '-'          CHR$(45)

        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00111110
        .db    %00000000
        .db    %00000000
        .db    %00000000

; $2E - Character: '.'          CHR$(46)

        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00011000
        .db    %00011000
        .db    %00000000

; $2F - Character: '/'          CHR$(47)

        .db    %00000000
        .db    %00000000
        .db    %00000010
        .db    %00000100
        .db    %00001000
        .db    %00010000
        .db    %00100000
        .db    %00000000

; $30 - Character: '0'          CHR$(48)

        .db    %00000000
        .db    %00111100
        .db    %01000110
        .db    %01001010
        .db    %01010010
        .db    %01100010
        .db    %00111100
        .db    %00000000

; $31 - Character: '1'          CHR$(49)

        .db    %00000000
        .db    %00011000
        .db    %00101000
        .db    %00001000
        .db    %00001000
        .db    %00001000
        .db    %00111110
        .db    %00000000

; $32 - Character: '2'          CHR$(50)

        .db    %00000000
        .db    %00111100
        .db    %01000010
        .db    %00000010
        .db    %00111100
        .db    %01000000
        .db    %01111110
        .db    %00000000

; $33 - Character: '3'          CHR$(51)

        .db    %00000000
        .db    %00111100
        .db    %01000010
        .db    %00001100
        .db    %00000010
        .db    %01000010
        .db    %00111100
        .db    %00000000

; $34 - Character: '4'          CHR$(52)

        .db    %00000000
        .db    %00001000
        .db    %00011000
        .db    %00101000
        .db    %01001000
        .db    %01111110
        .db    %00001000
        .db    %00000000

; $35 - Character: '5'          CHR$(53)

        .db    %00000000
        .db    %01111110
        .db    %01000000
        .db    %01111100
        .db    %00000010
        .db    %01000010
        .db    %00111100
        .db    %00000000

; $36 - Character: '6'          CHR$(54)

        .db    %00000000
        .db    %00111100
        .db    %01000000
        .db    %01111100
        .db    %01000010
        .db    %01000010
        .db    %00111100
        .db    %00000000

; $37 - Character: '7'          CHR$(55)

        .db    %00000000
        .db    %01111110
        .db    %00000010
        .db    %00000100
        .db    %00001000
        .db    %00010000
        .db    %00010000
        .db    %00000000

; $38 - Character: '8'          CHR$(56)

        .db    %00000000
        .db    %00111100
        .db    %01000010
        .db    %00111100
        .db    %01000010
        .db    %01000010
        .db    %00111100
        .db    %00000000

; $39 - Character: '9'          CHR$(57)

        .db    %00000000
        .db    %00111100
        .db    %01000010
        .db    %01000010
        .db    %00111110
        .db    %00000010
        .db    %00111100
        .db    %00000000

; $3A - Character: ':'          CHR$(58)

        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00010000
        .db    %00000000
        .db    %00000000
        .db    %00010000
        .db    %00000000

; $3B - Character: ';'          CHR$(59)

        .db    %00000000
        .db    %00000000
        .db    %00010000
        .db    %00000000
        .db    %00000000
        .db    %00010000
        .db    %00010000
        .db    %00100000

; $3C - Character: '<'          CHR$(60)

        .db    %00000000
        .db    %00000000
        .db    %00000100
        .db    %00001000
        .db    %00010000
        .db    %00001000
        .db    %00000100
        .db    %00000000

; $3D - Character: '='          CHR$(61)

        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00111110
        .db    %00000000
        .db    %00111110
        .db    %00000000
        .db    %00000000

; $3E - Character: '>'          CHR$(62)

        .db    %00000000
        .db    %00000000
        .db    %00010000
        .db    %00001000
        .db    %00000100
        .db    %00001000
        .db    %00010000
        .db    %00000000

; $3F - Character: '?'          CHR$(63)

        .db    %00000000
        .db    %00111100
        .db    %01000010
        .db    %00000100
        .db    %00001000
        .db    %00000000
        .db    %00001000
        .db    %00000000

; $40 - Character: '@'          CHR$(64)

        .db    %00000000
        .db    %00111100
        .db    %01001010
        .db    %01010110
        .db    %01011110
        .db    %01000000
        .db    %00111100
        .db    %00000000

; $41 - Character: 'A'          CHR$(65)

        .db    %00000000
        .db    %00111100
        .db    %01000010
        .db    %01000010
        .db    %01111110
        .db    %01000010
        .db    %01000010
        .db    %00000000

; $42 - Character: 'B'          CHR$(66)

        .db    %00000000
        .db    %01111100
        .db    %01000010
        .db    %01111100
        .db    %01000010
        .db    %01000010
        .db    %01111100
        .db    %00000000

; $43 - Character: 'C'          CHR$(67)

        .db    %00000000
        .db    %00111100
        .db    %01000010
        .db    %01000000
        .db    %01000000
        .db    %01000010
        .db    %00111100
        .db    %00000000

; $44 - Character: 'D'          CHR$(68)

        .db    %00000000
        .db    %01111000
        .db    %01000100
        .db    %01000010
        .db    %01000010
        .db    %01000100
        .db    %01111000
        .db    %00000000

; $45 - Character: 'E'          CHR$(69)

        .db    %00000000
        .db    %01111110
        .db    %01000000
        .db    %01111100
        .db    %01000000
        .db    %01000000
        .db    %01111110
        .db    %00000000

; $46 - Character: 'F'          CHR$(70)

        .db    %00000000
        .db    %01111110
        .db    %01000000
        .db    %01111100
        .db    %01000000
        .db    %01000000
        .db    %01000000
        .db    %00000000

; $47 - Character: 'G'          CHR$(71)

        .db    %00000000
        .db    %00111100
        .db    %01000010
        .db    %01000000
        .db    %01001110
        .db    %01000010
        .db    %00111100
        .db    %00000000

; $48 - Character: 'H'          CHR$(72)

        .db    %00000000
        .db    %01000010
        .db    %01000010
        .db    %01111110
        .db    %01000010
        .db    %01000010
        .db    %01000010
        .db    %00000000

; $49 - Character: 'I'          CHR$(73)

        .db    %00000000
        .db    %00111110
        .db    %00001000
        .db    %00001000
        .db    %00001000
        .db    %00001000
        .db    %00111110
        .db    %00000000

; $4A - Character: 'J'          CHR$(74)

        .db    %00000000
        .db    %00000010
        .db    %00000010
        .db    %00000010
        .db    %01000010
        .db    %01000010
        .db    %00111100
        .db    %00000000

; $4B - Character: 'K'          CHR$(75)

        .db    %00000000
        .db    %01000100
        .db    %01001000
        .db    %01110000
        .db    %01001000
        .db    %01000100
        .db    %01000010
        .db    %00000000

; $4C - Character: 'L'          CHR$(76)

        .db    %00000000
        .db    %01000000
        .db    %01000000
        .db    %01000000
        .db    %01000000
        .db    %01000000
        .db    %01111110
        .db    %00000000

; $4D - Character: 'M'          CHR$(77)

        .db    %00000000
        .db    %01000010
        .db    %01100110
        .db    %01011010
        .db    %01000010
        .db    %01000010
        .db    %01000010
        .db    %00000000

; $4E - Character: 'N'          CHR$(78)

        .db    %00000000
        .db    %01000010
        .db    %01100010
        .db    %01010010
        .db    %01001010
        .db    %01000110
        .db    %01000010
        .db    %00000000

; $4F - Character: 'O'          CHR$(79)

        .db    %00000000
        .db    %00111100
        .db    %01000010
        .db    %01000010
        .db    %01000010
        .db    %01000010
        .db    %00111100
        .db    %00000000

; $50 - Character: 'P'          CHR$(80)

        .db    %00000000
        .db    %01111100
        .db    %01000010
        .db    %01000010
        .db    %01111100
        .db    %01000000
        .db    %01000000
        .db    %00000000

; $51 - Character: 'Q'          CHR$(81)

        .db    %00000000
        .db    %00111100
        .db    %01000010
        .db    %01000010
        .db    %01010010
        .db    %01001010
        .db    %00111100
        .db    %00000000

; $52 - Character: 'R'          CHR$(82)

        .db    %00000000
        .db    %01111100
        .db    %01000010
        .db    %01000010
        .db    %01111100
        .db    %01000100
        .db    %01000010
        .db    %00000000

; $53 - Character: 'S'          CHR$(83)

        .db    %00000000
        .db    %00111100
        .db    %01000000
        .db    %00111100
        .db    %00000010
        .db    %01000010
        .db    %00111100
        .db    %00000000

; $54 - Character: 'T'          CHR$(84)

        .db    %00000000
        .db    %11111110
        .db    %00010000
        .db    %00010000
        .db    %00010000
        .db    %00010000
        .db    %00010000
        .db    %00000000

; $55 - Character: 'U'          CHR$(85)

        .db    %00000000
        .db    %01000010
        .db    %01000010
        .db    %01000010
        .db    %01000010
        .db    %01000010
        .db    %00111100
        .db    %00000000

; $56 - Character: 'V'          CHR$(86)

        .db    %00000000
        .db    %01000010
        .db    %01000010
        .db    %01000010
        .db    %01000010
        .db    %00100100
        .db    %00011000
        .db    %00000000

; $57 - Character: 'W'          CHR$(87)

        .db    %00000000
        .db    %01000010
        .db    %01000010
        .db    %01000010
        .db    %01000010
        .db    %01011010
        .db    %00100100
        .db    %00000000

; $58 - Character: 'X'          CHR$(88)

        .db    %00000000
        .db    %01000010
        .db    %00100100
        .db    %00011000
        .db    %00011000
        .db    %00100100
        .db    %01000010
        .db    %00000000

; $59 - Character: 'Y'          CHR$(89)

        .db    %00000000
        .db    %10000010
        .db    %01000100
        .db    %00101000
        .db    %00010000
        .db    %00010000
        .db    %00010000
        .db    %00000000

; $5A - Character: 'Z'          CHR$(90)

        .db    %00000000
        .db    %01111110
        .db    %00000100
        .db    %00001000
        .db    %00010000
        .db    %00100000
        .db    %01111110
        .db    %00000000

; $5B - Character: '['          CHR$(91)

        .db    %00000000
        .db    %00001110
        .db    %00001000
        .db    %00001000
        .db    %00001000
        .db    %00001000
        .db    %00001110
        .db    %00000000

; $5C - Character: '\'          CHR$(92)

        .db    %00000000
        .db    %00000000
        .db    %01000000
        .db    %00100000
        .db    %00010000
        .db    %00001000
        .db    %00000100
        .db    %00000000

; $5D - Character: ']'          CHR$(93)

        .db    %00000000
        .db    %01110000
        .db    %00010000
        .db    %00010000
        .db    %00010000
        .db    %00010000
        .db    %01110000
        .db    %00000000

; $5E - Character: '^'          CHR$(94)

        .db    %00000000
        .db    %00010000
        .db    %00111000
        .db    %01010100
        .db    %00010000
        .db    %00010000
        .db    %00010000
        .db    %00000000

; $5F - Character: '_'          CHR$(95)

        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %11111111

; $60 - Character: ' L '        CHR$(96)

        .db    %00000000
        .db    %00011100
        .db    %00100010
        .db    %01111000
        .db    %00100000
        .db    %00100000
        .db    %01111110
        .db    %00000000

; $61 - Character: 'a'          CHR$(97)

        .db    %00000000
        .db    %00000000
        .db    %00111000
        .db    %00000100
        .db    %00111100
        .db    %01000100
        .db    %00111100
        .db    %00000000

; $62 - Character: 'b'          CHR$(98)

        .db    %00000000
        .db    %00100000
        .db    %00100000
        .db    %00111100
        .db    %00100010
        .db    %00100010
        .db    %00111100
        .db    %00000000

; $63 - Character: 'c'          CHR$(99)

        .db    %00000000
        .db    %00000000
        .db    %00011100
        .db    %00100000
        .db    %00100000
        .db    %00100000
        .db    %00011100
        .db    %00000000

; $64 - Character: 'd'          CHR$(100)

        .db    %00000000
        .db    %00000100
        .db    %00000100
        .db    %00111100
        .db    %01000100
        .db    %01000100
        .db    %00111100
        .db    %00000000

; $65 - Character: 'e'          CHR$(101)

        .db    %00000000
        .db    %00000000
        .db    %00111000
        .db    %01000100
        .db    %01111000
        .db    %01000000
        .db    %00111100
        .db    %00000000

; $66 - Character: 'f'          CHR$(102)

        .db    %00000000
        .db    %00001100
        .db    %00010000
        .db    %00011000
        .db    %00010000
        .db    %00010000
        .db    %00010000
        .db    %00000000

; $67 - Character: 'g'          CHR$(103)

        .db    %00000000
        .db    %00000000
        .db    %00111100
        .db    %01000100
        .db    %01000100
        .db    %00111100
        .db    %00000100
        .db    %00111000

; $68 - Character: 'h'          CHR$(104)

        .db    %00000000
        .db    %01000000
        .db    %01000000
        .db    %01111000
        .db    %01000100
        .db    %01000100
        .db    %01000100
        .db    %00000000

; $69 - Character: 'i'          CHR$(105)

        .db    %00000000
        .db    %00010000
        .db    %00000000
        .db    %00110000
        .db    %00010000
        .db    %00010000
        .db    %00111000
        .db    %00000000

; $6A - Character: 'j'          CHR$(106)

        .db    %00000000
        .db    %00000100
        .db    %00000000
        .db    %00000100
        .db    %00000100
        .db    %00000100
        .db    %00100100
        .db    %00011000

; $6B - Character: 'k'          CHR$(107)

        .db    %00000000
        .db    %00100000
        .db    %00101000
        .db    %00110000
        .db    %00110000
        .db    %00101000
        .db    %00100100
        .db    %00000000

; $6C - Character: 'l'          CHR$(108)

        .db    %00000000
        .db    %00010000
        .db    %00010000
        .db    %00010000
        .db    %00010000
        .db    %00010000
        .db    %00001100
        .db    %00000000

; $6D - Character: 'm'          CHR$(109)

        .db    %00000000
        .db    %00000000
        .db    %01101000
        .db    %01010100
        .db    %01010100
        .db    %01010100
        .db    %01010100
        .db    %00000000

; $6E - Character: 'n'          CHR$(110)

        .db    %00000000
        .db    %00000000
        .db    %01111000
        .db    %01000100
        .db    %01000100
        .db    %01000100
        .db    %01000100
        .db    %00000000

; $6F - Character: 'o'          CHR$(111)

        .db    %00000000
        .db    %00000000
        .db    %00111000
        .db    %01000100
        .db    %01000100
        .db    %01000100
        .db    %00111000
        .db    %00000000

; $70 - Character: 'p'          CHR$(112)

        .db    %00000000
        .db    %00000000
        .db    %01111000
        .db    %01000100
        .db    %01000100
        .db    %01111000
        .db    %01000000
        .db    %01000000

; $71 - Character: 'q'          CHR$(113)

        .db    %00000000
        .db    %00000000
        .db    %00111100
        .db    %01000100
        .db    %01000100
        .db    %00111100
        .db    %00000100
        .db    %00000110

; $72 - Character: 'r'          CHR$(114)

        .db    %00000000
        .db    %00000000
        .db    %00011100
        .db    %00100000
        .db    %00100000
        .db    %00100000
        .db    %00100000
        .db    %00000000

; $73 - Character: 's'          CHR$(115)

        .db    %00000000
        .db    %00000000
        .db    %00111000
        .db    %01000000
        .db    %00111000
        .db    %00000100
        .db    %01111000
        .db    %00000000

; $74 - Character: 't'          CHR$(116)

        .db    %00000000
        .db    %00010000
        .db    %00111000
        .db    %00010000
        .db    %00010000
        .db    %00010000
        .db    %00001100
        .db    %00000000

; $75 - Character: 'u'          CHR$(117)

        .db    %00000000
        .db    %00000000
        .db    %01000100
        .db    %01000100
        .db    %01000100
        .db    %01000100
        .db    %00111000
        .db    %00000000

; $76 - Character: 'v'          CHR$(118)

        .db    %00000000
        .db    %00000000
        .db    %01000100
        .db    %01000100
        .db    %00101000
        .db    %00101000
        .db    %00010000
        .db    %00000000

; $77 - Character: 'w'          CHR$(119)

        .db    %00000000
        .db    %00000000
        .db    %01000100
        .db    %01010100
        .db    %01010100
        .db    %01010100
        .db    %00101000
        .db    %00000000

; $78 - Character: 'x'          CHR$(120)

        .db    %00000000
        .db    %00000000
        .db    %01000100
        .db    %00101000
        .db    %00010000
        .db    %00101000
        .db    %01000100
        .db    %00000000

; $79 - Character: 'y'          CHR$(121)

        .db    %00000000
        .db    %00000000
        .db    %01000100
        .db    %01000100
        .db    %01000100
        .db    %00111100
        .db    %00000100
        .db    %00111000

; $7A - Character: 'z'          CHR$(122)

        .db    %00000000
        .db    %00000000
        .db    %01111100
        .db    %00001000
        .db    %00010000
        .db    %00100000
        .db    %01111100
        .db    %00000000

; $7B - Character: '{'          CHR$(123)

        .db    %00000000
        .db    %00001110
        .db    %00001000
        .db    %00110000
        .db    %00001000
        .db    %00001000
        .db    %00001110
        .db    %00000000

; $7C - Character: '|'          CHR$(124)

        .db    %00000000
        .db    %00001000
        .db    %00001000
        .db    %00001000
        .db    %00001000
        .db    %00001000
        .db    %00001000
        .db    %00000000

; $7D - Character: '}'          CHR$(125)

        .db    %00000000
        .db    %01110000
        .db    %00010000
        .db    %00001100
        .db    %00010000
        .db    %00010000
        .db    %01110000
        .db    %00000000

; $7E - Character: '~'          CHR$(126)

        .db    %00000000
        .db    %00010100
        .db    %00101000
        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00000000
        .db    %00000000

; $7F - Character: '  '        CHR$(127)

        .db    %00111100
        .db    %01000010
        .db    %10011001
        .db    %10100001
        .db    %10100001
        .db    %10011001
        .db    %01000010
        .db    %00111100

        .end                             